<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>e1smmpanel™ - India's Fastest UPI Payment Gateway</title>
    <link rel="icon" href="https://tezgateway.com/common/img/logoshild.png">    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/aos@next/dist/aos.css" />
        <!-- Modern Design System -->
    <link rel="stylesheet" href="./aassetss/modern-design-system.css">
    <link rel="stylesheet" href="./styles.css">
    <meta http-equiv="X-Content-Type-Options" content="nosniff" />
    <meta http-equiv="X-Frame-Options" content="DENY" />
    <meta http-equiv="Referrer-Policy" content="no-referrer" />
    <meta name="robots" content="noindex, nofollow" />
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: '#00DDEB',
                        secondary: '#FF00FF',
                        dark: '#0F172A',
                        darker: '#1E1E2F'
                    },
                    animation: {
                        'float': 'float 5s ease-in-out infinite',
                        'pulse-slow': 'pulse 3s ease-in-out infinite',
                        'glow': 'glow 2s ease-in-out infinite alternate'
                    },
                    keyframes: {
                        float: {
                            '0%, 100%': { transform: 'translateY(0)' },
                            '50%': { transform: 'translateY(-15px)' }
                        },
                        pulse: {
                            '0%, 100%': { transform: 'scale(1)' },
                            '50%': { transform: 'scale(1.05)' }
                        },
                        glow: {
                            '0%': { boxShadow: '0 0 5px rgba(0, 221, 235, 0.7)' },
                            '100%': { boxShadow: '0 0 20px rgba(0, 221, 235, 1), 0 0 30px rgba(255, 0, 255, 0.7)' }
                        }
                    }
                }
            }
        }
    </script>
    <style>
        body {
            background: linear-gradient(135deg, #0F172A 0%, #1E1E2F 100%);
            overflow-x: hidden;
            scroll-behavior: smooth;
        }
        #particles-js {
            position: fixed;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            z-index: -1;
            opacity: 0.3;
        }
        .neon-border {
            border: 2px solid transparent;
            box-shadow: 0 0 15px #00DDEB, 0 0 30px #FF00FF;
            transition: all 0.3s ease;
        }
        .neon-button {
            background: linear-gradient(45deg, #00DDEB, #FF00FF);
            color: white;
            padding: 12px 24px;
            border-radius: 50px;
            font-weight: 600;
            box-shadow: 0 0 20px rgba(0, 221, 235, 0.7);
            text-decoration: none; /* Ensure no underline */
            display: inline-block; /* Ensure proper rendering */
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .neon-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 0 30px rgba(0, 221, 235, 1);
        }
        .neon-button.transparent {
            background: transparent;
            border: 2px solid #00DDEB;
            color: #00DDEB;
        }
        .neon-button.transparent:hover {
            background: #00DDEB;
            color: #1E1E2F;
        }
        .hero-bg {
            background: url('https://images.unsplash.com/photo-1620641788421-7a1c342ea42e?auto=format&fit=crop&w=1920&q=80') no-repeat center;
            background-size: cover;
            position: relative;
        }
        .hero-bg::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(135deg, rgba(0, 29, 61, 0.8), rgba(30, 30, 47, 0.8));
            z-index: 1;
        }
        .login-dropdown {
            position: relative;
        }
        .login-dropdown-content {
            position: absolute;
            top: 100%;
            left: 0;
            background: #1E1E2F;
            border-radius: 8px;
            padding: 8px 0;
            min-width: 180px;
            opacity: 0;
            visibility: hidden;
            transform: translateY(-10px);
            transition: opacity 0.3s ease, transform 0.3s ease;
            z-index: 1000;
            box-shadow: 0 0 10px rgba(0, 221, 235, 0.5);
        }
        .login-dropdown:hover .login-dropdown-content {
            opacity: 1;
            visibility: visible;
            transform: translateY(0);
        }
        .login-dropdown-content a {
            display: block;
            padding: 8px 16px;
            color: #D1D5DB;
            text-decoration: none;
            transition: color 0.3s ease, background 0.3s ease;
        }
        .login-dropdown-content a:hover {
            color: #00DDEB;
            background: rgba(255, 255, 255, 0.1);
        }
        .animate-pulse-slow {
            animation: pulse 3s ease-in-out infinite;
        }
        .animate-float {
            animation: float 5s ease-in-out infinite;
        }
        .animate-glow {
            animation: glow 2s ease-in-out infinite alternate;
        }
        @keyframes pulse {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.05); }
        }
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-15px); }
        }
        @keyframes glow {
            0% { box-shadow: 0 0 5px rgba(0, 221, 235, 0.7); }
            100% { boxShadow: '0 0 20px rgba(0, 221, 235, 1), 0 0 30px rgba(255, 0, 255, 0.7)'; }
        }
        .floating-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            border: 1px solid rgba(0, 221, 235, 0.3);
        }
        .floating-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 10px 25px -5px rgba(0, 221, 235, 0.4);
        }
        .mobile-menu {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(15, 23, 42, 0.95);
            z-index: 100;
            padding: 2rem;
            transform: translateX(-100%);
            transition: transform 0.3s ease-in-out;
        }
        .mobile-menu.active {
            transform: translateX(0);
            display: block;
        }
        .menu-toggle {
            z-index: 101;
        }
        .menu-toggle.active .bar:nth-child(1) {
            transform: rotate(45deg) translate(5px, 5px);
        }
        .menu-toggle.active .bar:nth-child(2) {
            opacity: 0;
        }
        .menu-toggle.active .bar:nth-child(3) {
            transform: rotate(-45deg) translate(7px, -6px);
        }
        .bar {
            transition: all 0.3s ease;
        }
        /* Responsive styles */
        @media (max-width: 768px) {
            .hero-visual {
                display: none;
            }
            .hero-text h1 {
                font-size: 2.5rem;
            }
            .hero-text p {
                font-size: 1rem;
            }
            .neon-button {
                padding: 10px 20px;
                font-size: 0.9rem;
            }
        }
        @media (max-width: 640px) {
            .hero-text h1 {
                font-size: 2rem;
            }
            .section-title {
                font-size: 1.75rem;
            }
        }
        /* Scroll indicator */
        .scroll-indicator {
            position: absolute;
            bottom: 30px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 10;
            animation: bounce 2s infinite;
        }
        @keyframes bounce {
            0%, 20%, 50%, 80%, 100% { transform: translateY(0) translateX(-50%); }
            40% { transform: translateY(-20px) translateX(-50%); }
            60% { transform: translateY(-10px) translateX(-50%); }
        }
    </style>
</head>
<body class="font-poppins text-white relative">
    <div id="particles-js"></div>

    <!-- Mobile Menu -->
    <div class="mobile-menu md:hidden">
        <div class="flex flex-col h-full">
            <div class="flex justify-end mb-8">
                <button class="close-menu text-white text-2xl">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <ul class="flex flex-col space-y-6 text-xl">
                <li><a href="#home" class="text-white hover:text-cyan-400 transition-colors block py-2">Home</a></li>
                <li><a href="#whatsapp" class="text-white hover:text-cyan-400 transition-colors block py-2">WhatsApp API</a></li>
                <li><a href="#services" class="text-white hover:text-cyan-400 transition-colors block py-2">Services</a></li>
                <li><a href="tc" class="text-white hover:text-cyan-400 transition-colors block py-2">Terms</a></li>
                <li class="py-2">
                    <span class="text-white mb-2 block">Login Options</span>
                    <ul class="pl-4 mt-2 space-y-2">
                        <li><a href="https://yo.e1smmpanel.in/auth/index.php" class="text-gray-300 hover:text-cyan-400 transition-colors block">TezGateway Login</a></li>
                        <li><a href="https://yo.e1smmpanel.in/#whatsapp" class="text-gray-300 hover:text-cyan-400 transition-colors block">WhatsApp API Login</a></li>
                    </ul>
                </li>
            </ul>
            <div class="mt-auto">
                <a href="https://yo.e1smmpanel.in/Register" class="neon-button w-full text-center mt-8">Get Started</a>
            </div>
        </div>
    </div>

    <header class="sticky top-0 z-50 bg-gray-900/90 backdrop-blur-sm neon-border rounded-b-lg animate-glow">
        <nav class="container mx-auto px-6 py-4 flex items-center justify-between">
            <div class="logo">
                <img src="https://tezgateway.com/logo.png" alt="TezGateway Logo" class="h-12 hover:scale-105 transition-transform">
            </div>
            <ul class="nav-links hidden md:flex items-center space-x-8">
                <li><a href="#home" class="text-gray-300 hover:text-cyan-400 transition-colors relative group">Home
                    <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-cyan-400 to-pink-500 transition-all duration-300 group-hover:w-full"></span>
                </a></li>
                <li><a href="#whatsapp" class="text-gray-300 hover:text-cyan-400 transition-colors relative group">WhatsApp API
                    <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-cyan-400 to-pink-500 transition-all duration-300 group-hover:w-full"></span>
                </a></li>
                <li><a href="#services" class="text-gray-300 hover:text-cyan-400 transition-colors relative group">Services
                    <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-cyan-400 to-pink-500 transition-all duration-300 group-hover:w-full"></span>
                </a></li>
                <li><a href="tc" class="text-gray-300 hover:text-cyan-400 transition-colors relative group">Terms
                    <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-cyan-400 to-pink-500 transition-all duration-300 group-hover:w-full"></span>
                </a></li>
                <li class="login-dropdown relative">
                    <a href="#" class="text-gray-300 hover:text-cyan-400 flex items-center relative group">
                        Login <i class="fas fa-chevron-down ml-1 text-sm"></i>
                        <span class="absolute -bottom-1 left-0 w-0 h-0.5 bg-gradient-to-r from-cyan-400 to-pink-500 transition-all duration-300 group-hover:w-full"></span>
                    </a>
                    <div class="login-dropdown-content">
                        <a href="https://yo.e1smmpanel.in/auth/index.php" class="block">TezGateway Login</a>
                        <a href="https://yo.e1smmpanel.in/#whatsapp" class="block">WhatsApp API Login</a>
                    </div>
                </li>
            </ul>
            <a href="https://yo.e1smmpanel.in/Register" class="neon-button hidden md:block">Get Started</a>
            <div class="menu-toggle md:hidden cursor-pointer">
                <div class="bar w-6 h-0.5 bg-cyan-400 mb-1.5"></div>
                <div class="bar w-6 h-0.5 bg-cyan-400 mb-1.5"></div>
                <div class="bar w-6 h-0.5 bg-cyan-400"></div>
            </div>
        </nav>
    </header>

    <main>
        <section id="home" class="hero-bg min-h-screen flex items-center pt-24 pb-32 relative">
            <div class="container mx-auto px-6 relative z-10">
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div class="hero-text" data-aos="fade-up">
                        <div class="inline-block px-3 py-1 rounded-full bg-gradient-to-r from-cyan-500/20 to-pink-500/20 backdrop-blur-sm mb-4">
                            <p class="text-sm font-medium text-cyan-400">India's #1 Payment Solution</p>
                        </div>
                        <h1 class="text-5xl md:text-6xl font-extrabold mb-6 leading-tight">
                            India's <span class="text-transparent bg-clip-text bg-gradient-to-r from-cyan-400 to-pink-500">Smartest</span> UPI Payment Gateway
                        </h1>
                        <p class="text-xl mb-8 opacity-90">TezGateway™ delivers real-time payments, seamless integrations, and unbeatable affordability starting at just ₹199/month!</p>
                        <div class="flex flex-wrap gap-4">
                            <a href="https://yo.e1smmpanel.in/auth/index.php" class="neon-button">Login Now</a>
                            <a href="https://yo.e1smmpanel.in/Register" class="neon-button transparent">Get Started</a>
                        </div>
                        <div class="mt-8 text-lg">
                            <div class="flex items-center gap-2 mb-2">
                                <div class="w-1.5 h-1.5 rounded-full bg-cyan-400"></div>
                                <p class="text-cyan-400 font-semibold">Trusted by <span class="text-white">1,000+ Businesses</span></p>
                            </div>
                            <div class="flex items-center gap-2">
                                <div class="w-1.5 h-1.5 rounded-full bg-green-400"></div>
                                <p>High Transaction Success Rate</p>
                            </div>
                        </div>
                    </div>
                    <div class="hero-visual" data-aos="fade-left">
                        <div class="relative bg-gray-800/50 p-8 rounded-2xl neon-border backdrop-blur-sm animate-pulse-slow overflow-hidden">
                            <div class="absolute -top-10 -right-10 w-40 h-40 bg-cyan-500/20 rounded-full blur-3xl"></div>
                            <div class="absolute -bottom-10 -left-10 w-40 h-40 bg-pink-500/20 rounded-full blur-3xl"></div>
                            
                            <h2 class="text-3xl font-bold mb-4 relative">Simplify Payments Today!</h2>
                            <p class="text-lg mb-6 relative">Fast. Secure. Affordable.</p>
                            
                            <div class="grid grid-cols-3 gap-3 mb-6 relative">
                                <a href="https://yo.e1smmpanel.in/Register" class="neon-button text-center text-sm py-3 px-2">QR Code</a>
                                <a href="https://yo.e1smmpanel.in/Register" class="neon-button text-center text-sm py-3 px-2">Intent Button</a>
                                <a href="https://yo.e1smmpanel.in/Register" class="neon-button text-center text-sm py-3 px-2">Pay Request</a>
                            </div>
                            
                            <div class="relative mt-6 p-4 bg-gray-900/50 rounded-lg border border-cyan-500/30">
                                <div class="flex items-center mb-2">
                                    <div class="w-3 h-3 rounded-full bg-red-500 mr-2"></div>
                                    <div class="w-3 h-3 rounded-full bg-yellow-500 mr-2"></div>
                                    <div class="w-3 h-3 rounded-full bg-green-500 mr-2"></div>
                                    <div class="text-xs text-gray-400 ml-2">payment-demo.js</div>
                                </div>
                                <pre class="text-xs text-cyan-400 overflow-x-auto"><code>// Initialize payment
const payment = new TezGateway({
  amount: 999.00,
  currency: 'INR',
  orderId: 'ORD12345',
  onSuccess: handleSuccess
});

// Start transaction
payment.start();</code></pre>
                            </div>
                            
                            <div class="floating-icons absolute w-full h-full top-0 left-0 pointer-events-none">
                                <i class="fas fa-mobile-alt text-3xl text-cyan-400 animate-float absolute" style="top: 10%; left: 10%;"></i>
                                <i class="fas fa-credit-card text-3xl text-pink-500 animate-float absolute" style="top: 15%; right: 15%; animation-delay: 1s;"></i>
                                <i class="fas fa-shield-alt text-3xl text-cyan-400 animate-float absolute" style="bottom: 20%; left: 20%; animation-delay: 2s;"></i>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Scroll indicator -->
                <div class="scroll-indicator hidden md:block">
                    <a href="#features" class="text-white opacity-80 hover:opacity-100 transition-opacity">
                        <i class="fas fa-chevron-down text-2xl"></i>
                    </a>
                </div>
            </div>
        </section>

        <section id="features" class="py-20 bg-gray-900 relative overflow-hidden">
            <!-- Background decorations -->
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden opacity-20 pointer-events-none">
                <div class="absolute top-0 left-0 w-96 h-96 bg-cyan-500 rounded-full filter blur-3xl opacity-20 transform -translate-x-1/2 -translate-y-1/2"></div>
                <div class="absolute bottom-0 right-0 w-96 h-96 bg-pink-500 rounded-full filter blur-3xl opacity-20 transform translate-x-1/2 translate-y-1/2"></div>
            </div>
            
            <div class="container mx-auto px-6 relative z-10">
                <div class="text-center mb-16" data-aos="fade-up">
                    <div class="inline-block px-3 py-1 rounded-full bg-gradient-to-r from-cyan-500/20 to-pink-500/20 backdrop-blur-sm mb-4">
                        <p class="text-sm font-medium text-cyan-400">Unmatched Benefits</p>
                    </div>
                    <h2 class="text-4xl font-bold mb-4">Why Choose <span class="text-transparent bg-clip-text bg-gradient-to-r from-cyan-400 to-pink-500">TezGateway™</span>?</h2>
                    <p class="text-gray-300 max-w-2xl mx-auto">Experience the perfect blend of speed, security, and affordability with our cutting-edge payment solutions.</p>
                </div>
                
                <div class="grid md:grid-cols-3 gap-8">
                    <div class="floating-card bg-gray-800/80 p-8 rounded-xl backdrop-blur-sm" data-aos="fade-up">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-cyan-500/20 to-cyan-500/10 flex items-center justify-center mb-6">
                            <i class="fas fa-bolt text-3xl text-cyan-400"></i>
                        </div>
                        <h3 class="text-xl font-semibold mb-3">Fastest UPI Gateway</h3>
                        <p class="text-gray-300">Real-time payment processing with 99.99% success rate. Experience lightning-fast transactions.</p>
                    </div>
                    
                    <div class="floating-card bg-gray-800/80 p-8 rounded-xl backdrop-blur-sm" data-aos="fade-up" data-aos-delay="100">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-pink-500/20 to-pink-500/10 flex items-center justify-center mb-6">
                            <i class="fas fa-rupee-sign text-3xl text-pink-400"></i>
                        </div>
                        <h3 class="text-xl font-semibold mb-3">Affordable Plans</h3>
                        <p class="text-gray-300">Starting at just ₹199/month with 0% hidden charges. Perfect for businesses of all sizes.</p>
                    </div>
                    
                    <div class="floating-card bg-gray-800/80 p-8 rounded-xl backdrop-blur-sm" data-aos="fade-up" data-aos-delay="200">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-cyan-500/20 to-cyan-500/10 flex items-center justify-center mb-6">
                            <i class="fas fa-plug text-3xl text-cyan-400"></i>
                        </div>
                        <h3 class="text-xl font-semibold mb-3">Seamless Integration</h3>
                        <p class="text-gray-300">Ready plugins for Laravel, PHP, Node.js, Android, iOS, and more. Integrate in minutes, not days.</p>
                    </div>
                    
                    <div class="floating-card bg-gray-800/80 p-8 rounded-xl backdrop-blur-sm" data-aos="fade-up" data-aos-delay="300">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-pink-500/20 to-pink-500/10 flex items-center justify-center mb-6">
                            <i class="fas fa-headset text-3xl text-pink-400"></i>
                        </div>
                        <h3 class="text-xl font-semibold mb-3">24x7 Support</h3>
                        <p class="text-gray-300">Instant assistance anytime, anywhere. Our expert team is always ready to help you succeed.</p>
                    </div>
                    
                    <div class="floating-card bg-gray-800/80 p-8 rounded-xl backdrop-blur-sm" data-aos="fade-up" data-aos-delay="400">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-cyan-500/20 to-cyan-500/10 flex items-center justify-center mb-6">
                            <i class="fas fa-shield-alt text-3xl text-cyan-400"></i>
                        </div>
                        <h3 class="text-xl font-semibold mb-3">Secure & Certified</h3>
                        <p class="text-gray-300">ISO-certified servers with secure APIs. Your data and transactions are always protected.</p>
                    </div>
                    
                    <div class="floating-card bg-gray-800/80 p-8 rounded-xl backdrop-blur-sm" data-aos="fade-up" data-aos-delay="500">
                        <div class="w-16 h-16 rounded-full bg-gradient-to-br from-pink-500/20 to-pink-500/10 flex items-center justify-center mb-6">
                            <i class="fas fa-users text-3xl text-pink-400"></i>
                        </div>
                        <h3 class="text-xl font-semibold mb-3">Trusted by 1,000+</h3>
                        <p class="text-gray-300">Join over 1,000 businesses already thriving with TezGateway. Be part of our success story.</p>
                    </div>
                </div>
                
                <div class="mt-16 text-center" data-aos="fade-up">
                    <a href="https://yo.e1smmpanel.in/Register" class="neon-button inline-flex items-center">
                        <span>Explore All Features</span>
                        <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
            </div>
        </section>
        <section id="whatsapp" class="py-20 bg-gray-900 relative overflow-hidden">
            <!-- Background decorations -->
            <div class="absolute top-0 right-0 w-96 h-96 bg-green-500 rounded-full filter blur-3xl opacity-10 transform translate-x-1/2 -translate-y-1/2"></div>
            <div class="absolute bottom-0 left-0 w-96 h-96 bg-cyan-500 rounded-full filter blur-3xl opacity-10 transform -translate-x-1/2 translate-y-1/2"></div>
            
            <div class="container mx-auto px-6 relative z-10">
                <div class="grid md:grid-cols-2 gap-12 items-center">
                    <div class="whatsapp-text" data-aos="fade-right">
                        <div class="inline-block px-3 py-1 rounded-full bg-gradient-to-r from-green-500/20 to-green-500/10 backdrop-blur-sm mb-4">
                            <p class="text-sm font-medium text-green-400">Official Partner</p>
                        </div>
                        <h2 class="text-4xl font-bold mb-6">WhatsApp <span class="text-transparent bg-clip-text bg-gradient-to-r from-green-400 to-cyan-400">WorkSpace</span></h2>
                        <p class="text-lg mb-8 opacity-90">Elevate customer engagement with our WhatsApp Business API. Automate, analyze, and connect like never before.</p>
                        
                        <div class="grid grid-cols-1 sm:grid-cols-2 gap-6 mb-8">
                            <div class="bg-gray-800/50 p-4 rounded-lg backdrop-blur-sm border border-green-500/20 hover:border-green-500/40 transition-colors">
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 rounded-full bg-green-500/20 flex items-center justify-center mr-3">
                                        <i class="fab fa-whatsapp text-xl text-green-400"></i>
                                    </div>
                                    <h3 class="font-semibold">Official WhatsApp API</h3>
                                </div>
                                <p class="text-sm text-gray-300">Verified by Meta, ensuring reliable and secure messaging.</p>
                            </div>
                            
                            <div class="bg-gray-800/50 p-4 rounded-lg backdrop-blur-sm border border-cyan-500/20 hover:border-cyan-500/40 transition-colors">
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 rounded-full bg-cyan-500/20 flex items-center justify-center mr-3">
                                        <i class="fas fa-robot text-xl text-cyan-400"></i>
                                    </div>
                                    <h3 class="font-semibold">Smart Automation</h3>
                                </div>
                                <p class="text-sm text-gray-300">Automate responses and workflows to save time and resources.</p>
                            </div>
                            
                            <div class="bg-gray-800/50 p-4 rounded-lg backdrop-blur-sm border border-cyan-500/20 hover:border-cyan-500/40 transition-colors">
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 rounded-full bg-cyan-500/20 flex items-center justify-center mr-3">
                                        <i class="fas fa-chart-line text-xl text-cyan-400"></i>
                                    </div>
                                    <h3 class="font-semibold">Real-Time Analytics</h3>
                                </div>
                                <p class="text-sm text-gray-300">Track performance metrics and customer engagement in real-time.</p>
                            </div>
                            
                            <div class="bg-gray-800/50 p-4 rounded-lg backdrop-blur-sm border border-cyan-500/20 hover:border-cyan-500/40 transition-colors">
                                <div class="flex items-center mb-3">
                                    <div class="w-10 h-10 rounded-full bg-cyan-500/20 flex items-center justify-center mr-3">
                                        <i class="fas fa-users text-xl text-cyan-400"></i>
                                    </div>
                                    <h3 class="font-semibold">Multi-Agent Support</h3>
                                </div>
                                <p class="text-sm text-gray-300">Collaborate with your team to provide seamless customer support.</p>
                            </div>
                        </div>
                        
                        <div class="flex flex-wrap gap-4">
                            <a href="https://wa.tezindia.in" class="neon-button inline-flex items-center">
                                <i class="fab fa-whatsapp mr-2"></i>
                                <span>Explore Now</span>
                            </a>
                            <a href="#" class="neon-button transparent inline-flex items-center">
                                <span>Watch Demo</span>
                                <i class="fas fa-play ml-2"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="whatsapp-image-container relative" data-aos="fade-left">
                        <div class="absolute inset-0 bg-gradient-to-br from-green-500/10 to-cyan-500/10 rounded-xl transform rotate-3"></div>
                        <img src="wa.png" alt="WhatsApp WorkSpace" class="rounded-xl shadow-2xl transform hover:scale-105 transition-transform relative z-10">
                        
                        <!-- Floating elements -->
                        <div class="absolute -top-6 -right-6 bg-gray-800/80 p-3 rounded-lg backdrop-blur-sm border border-green-500/30 shadow-xl animate-float z-20">
                            <div class="flex items-center">
                                <div class="w-8 h-8 rounded-full bg-green-500/20 flex items-center justify-center mr-2">
                                    <i class="fas fa-check text-green-400"></i>
                                </div>
                                <div>
                                    <p class="text-xs font-semibold">Message Delivered</p>
                                    <p class="text-xs text-gray-400">Just now</p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="absolute -bottom-6 -left-6 bg-gray-800/80 p-3 rounded-lg backdrop-blur-sm border border-cyan-500/30 shadow-xl animate-float z-20" style="animation-delay: 1s;">
                            <div class="flex items-center">
                                <div class="w-8 h-8 rounded-full bg-cyan-500/20 flex items-center justify-center mr-2">
                                    <i class="fas fa-chart-pie text-cyan-400"></i>
                                </div>
                                <div>
                                    <p class="text-xs font-semibold">98% Response Rate</p>
                                    <p class="text-xs text-gray-400">This week</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="plugins" class="py-20 bg-gray-800 relative overflow-hidden">
            <!-- Background decorations -->
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden opacity-10 pointer-events-none">
                <div class="absolute top-1/4 left-1/4 w-96 h-96 bg-blue-500 rounded-full filter blur-3xl opacity-20"></div>
                <div class="absolute bottom-1/4 right-1/4 w-96 h-96 bg-purple-500 rounded-full filter blur-3xl opacity-20"></div>
            </div>
            
            <div class="container mx-auto px-6 relative z-10">
                <div class="text-center mb-16" data-aos="fade-up">
                    <div class="inline-block px-3 py-1 rounded-full bg-gradient-to-r from-blue-500/20 to-purple-500/20 backdrop-blur-sm mb-4">
                        <p class="text-sm font-medium text-blue-400">Developer Friendly</p>
                    </div>
                    <h2 class="text-4xl font-bold mb-4">Ready-Made <span class="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500">Plugins & SDKs</span></h2>
                    <p class="text-gray-300 max-w-2xl mx-auto">Integrate our payment solutions with your favorite frameworks and languages in minutes.</p>
                </div>
                
                <div class="relative">
                    <!-- Gradient overlays for carousel effect -->
                    <div class="absolute left-0 top-0 bottom-0 w-16 bg-gradient-to-r from-gray-800 to-transparent z-10 pointer-events-none"></div>
                    <div class="absolute right-0 top-0 bottom-0 w-16 bg-gradient-to-l from-gray-800 to-transparent z-10 pointer-events-none"></div>
                    
                    <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-6 gap-4 md:gap-6">
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-blue-500/20 hover:border-blue-500/40 transition-all" data-aos="fade-up">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-laravel text-4xl text-red-500 mb-4"></i>
                                <h3 class="text-lg font-semibold">Laravel</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-blue-500/20 hover:border-blue-500/40 transition-all" data-aos="fade-up" data-aos-delay="50">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-php text-4xl text-blue-500 mb-4"></i>
                                <h3 class="text-lg font-semibold">PHP SDK</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-green-500/20 hover:border-green-500/40 transition-all" data-aos="fade-up" data-aos-delay="100">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-node-js text-4xl text-green-500 mb-4"></i>
                                <h3 class="text-lg font-semibold">Node.js</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-green-500/20 hover:border-green-500/40 transition-all" data-aos="fade-up" data-aos-delay="150">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-android text-4xl text-green-400 mb-4"></i>
                                <h3 class="text-lg font-semibold">Android SDK</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-cyan-500/20 hover:border-cyan-500/40 transition-all" data-aos="fade-up" data-aos-delay="200">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-react text-4xl text-cyan-400 mb-4"></i>
                                <h3 class="text-lg font-semibold">React Native</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-blue-500/20 hover:border-blue-500/40 transition-all" data-aos="fade-up" data-aos-delay="250">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fas fa-dove text-4xl text-blue-400 mb-4"></i>
                                <h3 class="text-lg font-semibold">Flutter</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-orange-500/20 hover:border-orange-500/40 transition-all" data-aos="fade-up" data-aos-delay="300">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-java text-4xl text-orange-500 mb-4"></i>
                                <h3 class="text-lg font-semibold">Java SDK</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-yellow-500/20 hover:border-yellow-500/40 transition-all" data-aos="fade-up" data-aos-delay="350">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-python text-4xl text-yellow-400 mb-4"></i>
                                <h3 class="text-lg font-semibold">Python SDK</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-blue-500/20 hover:border-blue-500/40 transition-all" data-aos="fade-up" data-aos-delay="400">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-windows text-4xl text-blue-500 mb-4"></i>
                                <h3 class="text-lg font-semibold">C# SDK</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-red-500/20 hover:border-red-500/40 transition-all" data-aos="fade-up" data-aos-delay="450">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-gem text-4xl text-red-400 mb-4"></i>
                                <h3 class="text-lg font-semibold">Ruby SDK</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-yellow-500/20 hover:border-yellow-500/40 transition-all" data-aos="fade-up" data-aos-delay="500">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fab fa-js text-4xl text-yellow-500 mb-4"></i>
                                <h3 class="text-lg font-semibold">JavaScript</h3>
                            </div>
                        </div>
                        
                        <div class="floating-card bg-gray-700/80 p-6 rounded-xl backdrop-blur-sm border border-gray-500/20 hover:border-gray-500/40 transition-all" data-aos="fade-up" data-aos-delay="550">
                            <div class="flex flex-col items-center justify-center h-full">
                                <i class="fas fa-code text-4xl text-gray-400 mb-4"></i>
                                <h3 class="text-lg font-semibold">C++ SDK</h3>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="mt-12 text-center" data-aos="fade-up">
                    <p class="text-lg mb-6">And plugins for <span class="text-transparent bg-clip-text bg-gradient-to-r from-cyan-400 to-pink-500 font-semibold">all major frameworks</span>!</p>
                    <a href="#" class="inline-flex items-center text-cyan-400 hover:text-cyan-300 transition-colors">
                        <span>View all integrations</span>
                        <i class="fas fa-arrow-right ml-2"></i>
                    </a>
                </div>
                
                <!-- Code snippet -->
                <div class="mt-16 max-w-3xl mx-auto bg-gray-900/80 rounded-xl p-6 backdrop-blur-sm border border-cyan-500/20" data-aos="fade-up">
                    <div class="flex items-center mb-4">
                        <div class="w-3 h-3 rounded-full bg-red-500 mr-2"></div>
                        <div class="w-3 h-3 rounded-full bg-yellow-500 mr-2"></div>
                        <div class="w-3 h-3 rounded-full bg-green-500 mr-2"></div>
                        <div class="text-xs text-gray-400 ml-2">integration-example.js</div>
                    </div>
                    <pre class="text-sm text-cyan-400 overflow-x-auto"><code>// Initialize TezGateway with your API key
const tezGateway = new TezGateway({
  apiKey: 'YOUR_API_KEY',
  environment: 'production' // or 'sandbox' for testing
});

// Create a payment request
const paymentRequest = await tezGateway.createPayment({
  amount: 1999.00,
  currency: 'INR',
  orderId: 'ORDER_' + Date.now(),
  customerName: 'John Doe',
  customerEmail: 'john@example.com',
  customerPhone: '9876543210',
  description: 'Premium Plan Subscription'
});

// Redirect to payment page or show QR code
tezGateway.showPaymentPage(paymentRequest.id);</code></pre>
                </div>
            </div>
        </section>

        <section id="testimonials" class="py-20 bg-gray-800 relative overflow-hidden">
            <!-- Background decorations -->
            <div class="absolute top-0 left-0 w-full h-full overflow-hidden opacity-10 pointer-events-none">
                <div class="absolute top-1/3 right-1/4 w-96 h-96 bg-yellow-500 rounded-full filter blur-3xl opacity-20"></div>
                <div class="absolute bottom-1/3 left-1/4 w-96 h-96 bg-purple-500 rounded-full filter blur-3xl opacity-20"></div>
            </div>
            
            <div class="container mx-auto px-6 relative z-10">
                <div class="text-center mb-16" data-aos="fade-up">
                    <div class="inline-block px-3 py-1 rounded-full bg-gradient-to-r from-yellow-500/20 to-orange-500/20 backdrop-blur-sm mb-4">
                        <p class="text-sm font-medium text-yellow-400">Customer Success Stories</p>
                    </div>
                    <h2 class="text-4xl font-bold mb-4">Trusted by <span class="text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-orange-500">Businesses</span></h2>
                    <p class="text-gray-300 max-w-2xl mx-auto">See what our customers are saying about their experience with TezGateway™.</p>
                </div>
                
                <div class="grid md:grid-cols-3 gap-8">
                                            <div class="floating-card bg-gray-700/80 p-8 rounded-xl backdrop-blur-sm border border-yellow-500/10 hover:border-yellow-500/30 transition-all group" data-aos="fade-up">
                            <!-- Quote icon -->
                            <div class="absolute top-6 right-6 text-yellow-500/20 group-hover:text-yellow-500/40 transition-colors">
                                <i class="fas fa-quote-right text-4xl"></i>
                            </div>
                            
                            <!-- Testimonial content -->
                            <p class="text-gray-300 mb-6 relative z-10">"We are using TezGateway best support and services with 7 merchant and reasonable prices 👍"</p>
                            
                            <!-- Author info with improved layout -->
                            <div class="flex items-center">
                                <div>
                                    <h3 class="font-semibold text-white">Rabin Kumar Dutta</h3>
                                    <p class="text-sm text-cyan-400">Founder, CEO - RB NEXT</p>
                                </div>
                            </div>
                        </div>
                                            <div class="floating-card bg-gray-700/80 p-8 rounded-xl backdrop-blur-sm border border-yellow-500/10 hover:border-yellow-500/30 transition-all group" data-aos="fade-up">
                            <!-- Quote icon -->
                            <div class="absolute top-6 right-6 text-yellow-500/20 group-hover:text-yellow-500/40 transition-colors">
                                <i class="fas fa-quote-right text-4xl"></i>
                            </div>
                            
                            <!-- Testimonial content -->
                            <p class="text-gray-300 mb-6 relative z-10">"TezGateway helped us focus on our core business without worrying about payment issues."</p>
                            
                            <!-- Author info with improved layout -->
                            <div class="flex items-center">
                                <div>
                                    <h3 class="font-semibold text-white">Derek Malone</h3>
                                    <p class="text-sm text-cyan-400">CTO</p>
                                </div>
                            </div>
                        </div>
                                            <div class="floating-card bg-gray-700/80 p-8 rounded-xl backdrop-blur-sm border border-yellow-500/10 hover:border-yellow-500/30 transition-all group" data-aos="fade-up">
                            <!-- Quote icon -->
                            <div class="absolute top-6 right-6 text-yellow-500/20 group-hover:text-yellow-500/40 transition-colors">
                                <i class="fas fa-quote-right text-4xl"></i>
                            </div>
                            
                            <!-- Testimonial content -->
                            <p class="text-gray-300 mb-6 relative z-10">"Our experience working with TezGateway has been great. For our core consumer payments solution, TezGateway has helped us achieve good payment success rates."</p>
                            
                            <!-- Author info with improved layout -->
                            <div class="flex items-center">
                                <div>
                                    <h3 class="font-semibold text-white">Stella Pierce</h3>
                                    <p class="text-sm text-cyan-400">CFO</p>
                                </div>
                            </div>
                        </div>
                                    </div>
                
                <!-- Testimonial stats -->
                <div class="mt-16 grid grid-cols-2 md:grid-cols-4 gap-8 text-center" data-aos="fade-up">
                    <div class="p-6">
                        <div class="text-4xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-orange-500 mb-2">1,000+</div>
                        <p class="text-gray-400">Happy Customers</p>
                    </div>
                    <div class="p-6">
                        <div class="text-4xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-orange-500 mb-2">₹50Cr+</div>
                        <p class="text-gray-400">Transactions Processed</p>
                    </div>
                    <div class="p-6">
                        <div class="text-4xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-orange-500 mb-2">99.9%</div>
                        <p class="text-gray-400">Uptime</p>
                    </div>
                    <div class="p-6">
                        <div class="text-4xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-yellow-400 to-orange-500 mb-2">24/7</div>
                        <p class="text-gray-400">Customer Support</p>
                    </div>
                </div>
            </div>
        </section>

        <section id="cta" class="py-24 bg-gradient-to-r from-cyan-500 to-pink-500 text-white text-center relative overflow-hidden">
            <!-- Animated background elements -->
            <div class="absolute inset-0 overflow-hidden pointer-events-none">
                <div class="absolute top-0 left-0 w-full h-full">
                    <div class="absolute top-1/4 left-1/4 w-64 h-64 bg-white rounded-full mix-blend-overlay filter blur-3xl opacity-20 animate-pulse-slow"></div>
                    <div class="absolute bottom-1/4 right-1/4 w-64 h-64 bg-white rounded-full mix-blend-overlay filter blur-3xl opacity-20 animate-pulse-slow animation-delay-1000"></div>
                </div>
                <!-- Floating particles -->
                <div class="absolute top-10 left-10 w-8 h-8 bg-white rounded-full opacity-20 animate-float"></div>
                <div class="absolute top-3/4 left-1/4 w-6 h-6 bg-white rounded-full opacity-20 animate-float animation-delay-1000"></div>
                <div class="absolute top-1/2 right-1/4 w-10 h-10 bg-white rounded-full opacity-20 animate-float animation-delay-2000"></div>
                <div class="absolute bottom-10 right-10 w-8 h-8 bg-white rounded-full opacity-20 animate-float animation-delay-3000"></div>
            </div>
            
            <div class="container mx-auto px-6 relative z-10">
                <div class="max-w-4xl mx-auto">
                    <div class="inline-block px-4 py-1 rounded-full bg-white/20 backdrop-blur-sm mb-6" data-aos="fade-down">
                        <p class="text-sm font-medium">Limited Time Offer</p>
                    </div>
                    
                    <h2 class="text-4xl md:text-5xl lg:text-6xl font-bold mb-6" data-aos="zoom-in">
                        Ready to <span class="relative inline-block">
                            <span class="relative z-10">Transform</span>
                            <span class="absolute bottom-0 left-0 w-full h-3 bg-white/20 rounded-full -z-10"></span>
                        </span> Your Payments?
                    </h2>
                    
                    <p class="text-xl md:text-2xl mb-10 max-w-2xl mx-auto" data-aos="fade-up" data-aos-delay="100">Join 1,000+ businesses thriving with TezGateway™. Start for just <span class="font-bold">₹199/month!</span></p>
                    
                    <div class="flex flex-col sm:flex-row items-center justify-center gap-4 mb-10">
                        <a href="https://yo.e1smmpanel.in/Register" class="w-full sm:w-auto neon-button text-lg px-10 py-4 rounded-lg font-bold shadow-lg shadow-cyan-500/30 hover:shadow-cyan-500/50 transition-all duration-300" data-aos="fade-up" data-aos-delay="200">
                            <i class="fas fa-rocket mr-2"></i> Get Started Now
                        </a>
                        
                        <a href="#" class="w-full sm:w-auto inline-block bg-white/10 backdrop-blur-sm text-white px-10 py-4 rounded-lg font-bold hover:bg-white/20 transition-all duration-300 border border-white/20" data-aos="fade-up" data-aos-delay="300">
                            <i class="fas fa-calendar-alt mr-2"></i> Schedule Demo
                        </a>
                    </div>
                    
                    <!-- Features list -->
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-6 max-w-3xl mx-auto" data-aos="fade-up" data-aos-delay="400">
                        <div class="flex items-center justify-center">
                            <i class="fas fa-check-circle mr-2 text-cyan-200"></i>
                            <span>No setup fee</span>
                        </div>
                        <div class="flex items-center justify-center">
                            <i class="fas fa-check-circle mr-2 text-cyan-200"></i>
                            <span>Cancel anytime</span>
                        </div>
                        <div class="flex items-center justify-center">
                            <i class="fas fa-check-circle mr-2 text-cyan-200"></i>
                            <span>24/7 support</span>
                        </div>
                        <div class="flex items-center justify-center">
                            <i class="fas fa-check-circle mr-2 text-cyan-200"></i>
                            <span>Instant setup</span>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <footer class="bg-gray-900 text-gray-300 py-16 relative overflow-hidden">
        <!-- Background decorations -->
        <div class="absolute top-0 left-0 w-full h-1 bg-gradient-to-r from-cyan-500 to-pink-500 opacity-80"></div>
        <div class="absolute bottom-0 left-0 w-full h-px bg-gray-800"></div>
        
        <div class="container mx-auto px-6">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-12 mb-12">
                <!-- Company info -->
                <div class="md:col-span-1">
                    <div class="flex items-center mb-6">
                        <div class="text-3xl font-bold text-white mr-2">Tez<span class="text-cyan-400">Gateway</span></div>
                        <div class="text-xs align-top bg-cyan-500 text-white px-1.5 py-0.5 rounded">™</div>
                    </div>
                    <p class="text-gray-400 mb-6">India's most reliable payment gateway with the highest success rate and lowest transaction fees.</p>
                    <div class="flex space-x-4">
                        <a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">
                            <i class="fab fa-facebook-f"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">
                            <i class="fab fa-instagram"></i>
                        </a>
                        <a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                    </div>
                </div>
                
                <!-- Quick Links -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-6">Quick Links</h3>
                    <ul class="space-y-3">
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Home</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">WhatsApp API</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Services</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Pricing</a></li>
                        <!--<li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Contact</a></li>-->
                    </ul>
                </div>
                
                <!-- Resources -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-6">Resources</h3>
                    <ul class="space-y-3">
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Documentation</a></li>
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">API Reference</a></li>
                        <!--<li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Blog</a></li>-->
                        <li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Support Center</a></li>
                        <!--<li><a href="#" class="text-gray-400 hover:text-cyan-400 transition-colors">Status</a></li>-->
                    </ul>
                </div>
                
                <!-- Contact -->
                <div>
                    <h3 class="text-lg font-semibold text-white mb-6">Contact Us</h3>
                    <ul class="space-y-3">
                        <li class="flex items-start">
                            <i class="fas fa-map-marker-alt text-cyan-400 mt-1 mr-3"></i>
                            <span class="text-gray-400">24/7 Chatbot Support available inside login</span>
                        </li>
                        <!--<li class="flex items-center">-->
                        <!--    <i class="fas fa-phone-alt text-cyan-400 mr-3"></i>-->
                        <!--    <span class="text-gray-400">+91 98765 43210</span>-->
                        <!--</li>-->
                        <li class="flex items-center">
                            <i class="fas fa-envelope text-cyan-400 mr-3"></i>
                            <span class="text-gray-400">tezindia.business@gmail.com</span>
                        </li>
                    </ul>
                </div>
            </div>
            
            <!-- Payment methods -->
            <div class="border-t border-gray-800 pt-8 pb-4">
                <div class="flex flex-wrap justify-center gap-4 mb-6">
                    <!-- Using SVG for payment icons instead of placeholder images -->
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M293.2 348.7H486.8V337.3L475.4 325.9H304.6L293.2 337.3V348.7Z" fill="#F79410"/>
                            <path d="M304.6 162.8H475.4L486.8 174.2V185.6H293.2V174.2L304.6 162.8Z" fill="#F79410"/>
                            <path d="M304.6 162.8H475.4V325.9H304.6V162.8Z" fill="#FF5F00"/>
                            <path d="M331.9 244.3C331.9 209.9 347.8 179.2 373.1 162.8C354.5 148.5 331.1 140 305.7 140C237.3 140 182 186.8 182 244.3C182 301.8 237.3 348.7 305.7 348.7C331.1 348.7 354.5 340.1 373.1 325.9C347.8 309.5 331.9 278.8 331.9 244.3Z" fill="#EB001B"/>
                            <path d="M598 244.3C598 301.8 542.7 348.7 474.3 348.7C448.9 348.7 425.5 340.1 406.9 325.9C432.2 309.4 448.1 278.8 448.1 244.3C448.1 209.9 432.2 179.2 406.9 162.8C425.5 148.5 448.9 140 474.3 140C542.7 140 598 186.8 598 244.3Z" fill="#F79E1B"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M290 320H250V170H290V320Z" fill="#00579F"/>
                            <path d="M376.8 172.7C366.4 169 351.5 165 333.7 165C283.3 165 249 191.1 249 229.5C249 258.9 274.1 275 292.9 285C312 295 318.5 301.5 318.5 310.5C318.5 324 301.9 330.5 286.4 330.5C265.1 330.5 253.3 326.8 235.8 318.5L229.3 315.5L222.5 350.5C235.5 356.8 259.9 362 285.1 362.3C339 362.3 372.5 336.5 372.5 295.8C372.5 272.8 356.5 255 328.5 240.5C311.9 231.5 301.9 225 301.9 215C301.9 206 312 197 332.4 197C349 196.7 361 201 370.3 205.3L374.8 207.7L381.8 174.7L376.8 172.7Z" fill="#00579F"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M483.4 208.8H296.6V291.2H483.4V208.8Z" fill="#006FCF"/>
                            <path d="M311.5 250C311.5 228.8 328.7 211.6 349.9 211.6H430.1C451.3 211.6 468.5 228.8 468.5 250C468.5 271.2 451.3 288.4 430.1 288.4H349.9C328.7 288.4 311.5 271.2 311.5 250Z" fill="white"/>
                            <path d="M334.1 165.7L390 334.3H364.5L352.9 301.5H299.1L287.5 334.3H262L317.9 165.7H334.1ZM345.7 281.9L326 227.7L306.3 281.9H345.7Z" fill="#006FCF"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M389.7 205.1C376.8 205.1 366.3 215.6 366.3 228.5C366.3 241.4 376.8 251.9 389.7 251.9C402.6 251.9 413.1 241.4 413.1 228.5C413.1 215.6 402.6 205.1 389.7 205.1Z" fill="#003087"/>
                            <path d="M446.8 228.5C446.8 248.1 431 264 411.4 264C391.8 264 376 248.1 376 228.5C376 209 391.8 193.1 411.4 193.1C431 193.1 446.8 209 446.8 228.5ZM411.4 180.1C384.7 180.1 363 201.8 363 228.5C363 255.2 384.7 276.9 411.4 276.9C438.1 276.9 459.8 255.2 459.8 228.5C459.8 201.8 438.1 180.1 411.4 180.1Z" fill="#009CDE"/>
                            <path d="M505.9 180.1H492.9V276.9H505.9C532.6 276.9 554.3 255.2 554.3 228.5C554.3 201.8 532.6 180.1 505.9 180.1ZM505.9 264C499.9 264 492.9 257 492.9 251V193.1C492.9 187.1 499.9 193.1 505.9 193.1C525.5 193.1 541.3 209 541.3 228.5C541.3 248.1 525.5 264 505.9 264Z" fill="#003087"/>
                            <path d="M321.5 180.1H308.5V276.9H321.5C348.2 276.9 369.9 255.2 369.9 228.5C369.9 201.8 348.2 180.1 321.5 180.1ZM321.5 264C315.5 264 308.5 257 308.5 251V193.1C308.5 187.1 315.5 193.1 321.5 193.1C341.1 193.1 356.9 209 356.9 228.5C356.9 248.1 341.1 264 321.5 264Z" fill="#009CDE"/>
                            <path d="M273.9 180.1H260.9C234.2 180.1 212.5 201.8 212.5 228.5C212.5 255.2 234.2 276.9 260.9 276.9H273.9V264C267.9 264 260.9 257 260.9 251V206C260.9 200 267.9 193.1 273.9 193.1V180.1Z" fill="#003087"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M390 180C335.3 180 291 224.3 291 279C291 333.7 335.3 378 390 378C444.7 378 489 333.7 489 279C489 224.3 444.7 180 390 180ZM390 341C355.7 341 328 313.3 328 279C328 244.7 355.7 217 390 217C424.3 217 452 244.7 452 279C452 313.3 424.3 341 390 341Z" fill="#213B7E"/>
                            <path d="M390 217C355.7 217 328 244.7 328 279C328 313.3 355.7 341 390 341C424.3 341 452 313.3 452 279C452 244.7 424.3 217 390 217ZM390 329C362.4 329 340 306.6 340 279C340 251.4 362.4 229 390 229C417.6 229 440 251.4 440 279C440 306.6 417.6 329 390 329Z" fill="#213B7E"/>
                            <path d="M390 229C362.4 229 340 251.4 340 279C340 306.6 362.4 329 390 329C417.6 329 440 306.6 440 279C440 251.4 417.6 229 390 229ZM390 305C375.7 305 364 293.3 364 279C364 264.7 375.7 253 390 253C404.3 253 416 264.7 416 279C416 293.3 404.3 305 390 305Z" fill="#213B7E"/>
                            <path d="M390 253C375.7 253 364 264.7 364 279C364 293.3 375.7 305 390 305C404.3 305 416 293.3 416 279C416 264.7 404.3 253 390 253Z" fill="#213B7E"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M390 180C335.3 180 291 224.3 291 279C291 333.7 335.3 378 390 378C444.7 378 489 333.7 489 279C489 224.3 444.7 180 390 180Z" fill="#4285F4"/>
                            <path d="M390 279L428.5 240.5C421.5 233.5 411.5 229 400.5 229C378.5 229 360.5 247 360.5 269C360.5 291 378.5 309 400.5 309C411.5 309 421.5 304.5 428.5 297.5L390 279Z" fill="#34A853"/>
                            <path d="M428.5 240.5L390 279L428.5 297.5C435.5 290.5 440 280.5 440 269.5C440 258.5 435.5 248.5 428.5 240.5Z" fill="#FBBC04"/>
                            <path d="M351.5 240.5C344.5 248.5 340 258.5 340 269.5C340 280.5 344.5 290.5 351.5 297.5L390 279L351.5 240.5Z" fill="#EA4335"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M390 180C335.3 180 291 224.3 291 279C291 333.7 335.3 378 390 378C444.7 378 489 333.7 489 279C489 224.3 444.7 180 390 180Z" fill="#5F259F"/>
                            <path d="M390 217C355.7 217 328 244.7 328 279C328 313.3 355.7 341 390 341C424.3 341 452 313.3 452 279C452 244.7 424.3 217 390 217ZM390 329C362.4 329 340 306.6 340 279C340 251.4 362.4 229 390 229C417.6 229 440 251.4 440 279C440 306.6 417.6 329 390 329Z" fill="white"/>
                            <path d="M390 229C362.4 229 340 251.4 340 279C340 306.6 362.4 329 390 329C417.6 329 440 306.6 440 279C440 251.4 417.6 229 390 229Z" fill="#5F259F"/>
                            <path d="M390 253C375.7 253 364 264.7 364 279C364 293.3 375.7 305 390 305C404.3 305 416 293.3 416 279C416 264.7 404.3 253 390 253Z" fill="white"/>
                        </svg>
                    </div>
                    <div class="h-8 w-12 bg-white rounded px-1 py-0.5 flex items-center justify-center grayscale hover:grayscale-0 transition-all duration-300">
                        <svg viewBox="0 0 780 500" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-full">
                            <path d="M40 0H740C762.1 0 780 17.9 780 40V460C780 482.1 762.1 500 740 500H40C17.9 500 0 482.1 0 460V40C0 17.9 17.9 0 40 0Z" fill="white"/>
                            <path d="M390 180C335.3 180 291 224.3 291 279C291 333.7 335.3 378 390 378C444.7 378 489 333.7 489 279C489 224.3 444.7 180 390 180Z" fill="#00BAF2"/>
                            <path d="M390 217C355.7 217 328 244.7 328 279C328 313.3 355.7 341 390 341C424.3 341 452 313.3 452 279C452 244.7 424.3 217 390 217Z" fill="#002970"/>
                            <path d="M390 229C362.4 229 340 251.4 340 279C340 306.6 362.4 329 390 329C417.6 329 440 306.6 440 279C440 251.4 417.6 229 390 229Z" fill="#00BAF2"/>
                            <path d="M390 253C375.7 253 364 264.7 364 279C364 293.3 375.7 305 390 305C404.3 305 416 293.3 416 279C416 264.7 404.3 253 390 253Z" fill="white"/>
                        </svg>
                    </div>
                </div>
            </div>
            
            <!-- Copyright -->
            <div class="text-center pt-4 border-t border-gray-800">
                <p class="text-sm text-gray-500">© 2025 TezGateway™. All Rights Reserved.</p>
                <div class="flex justify-center space-x-4 mt-4 text-xs text-gray-500">
                    <a href="#" class="hover:text-gray-400 transition-colors">Privacy Policy</a>
                    <a href="#" class="hover:text-gray-400 transition-colors">Terms of Service</a>
                    <a href="#" class="hover:text-gray-400 transition-colors">Refund Policy</a>
                    <a href="#" class="hover:text-gray-400 transition-colors">Legal</a>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/particles.js/2.0.0/particles.min.js"></script>
    <script>
        particlesJS("particles-js", {
            particles: {
                number: { value: 100, density: { enable: true, value_area: 800 } },
                color: { value: ["#00DDEB", "#FF00FF"] },
                shape: { type: "circle" },
                opacity: { value: 0.5, random: true },
                size: { value: 3, random: true },
                line_linked: { enable: true, distance: 150, color: "#FF00FF", opacity: 0.4, width: 1 },
                move: { enable: true, speed: 4, direction: "none", random: true, straight: false, out_mode: "out" }
            },
            interactivity: {
                detect_on: "canvas",
                events: { onhover: { enable: true, mode: "repulse" }, onclick: { enable: true, mode: "push" }, resize: true },
                modes: { push: { particles_nb: 4 } }
            },
            retina_detect: true
        });
    </script>
    <script src="https://unpkg.com/aos@next/dist/aos.js"></script>
    <script>
        AOS.init({ duration: 1200, once: true });

        const menuToggle = document.querySelector('.menu-toggle');
        const navLinks = document.querySelector('.nav-links');
        menuToggle.addEventListener('click', () => {
            navLinks.classList.toggle('active');
            menuToggle.classList.toggle('active');
        });

        document.querySelectorAll('.nav-link').forEach(link => {
            link.addEventListener('click', () => {
                navLinks.classList.remove('active');
                menuToggle.classList.remove('active');
            });
        });
    </script>
    <style>
        @keyframes float {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-15px); }
        }
        .animate-float {
            animation: float 5s ease-in-out infinite;
        }
        .nav-links.active {
            display: block;
            position: absolute;
            top: 100%;
            left: 0;
            right: 0;
            background: #1E1E2F;
            padding: 20px;
        }
    </style>
</body>
</html>